<?php
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreLista extends VisualizzatoreComponente {
        
        private $icona;
        private $aliasLista;
        private $datiLista;
                
        function __construct($db) {
            parent::__construct($db);
        }
        
        function generaContenutoSezione($dati) {
            $this->datiLista = parent::getDb()->leggiSingolaRiga("geec_liste",$dati["idElemento"]);
            
            $this->icona = $this->datiLista["icona"];
            $this->aliasLista = str_replace(" ","-",$this->datiLista["nome"]);
            
            $classeBaseSezione = (strpos($this->datiLista["tipoVisualizzazione"], 'sequenza') !== false) ? "lista sequenza" : "lista";
            echo"<div class=\"{$this->datiLista["spazioOccupato"]}\">
                    <div class=\"row\">
                        <div class=\"col-md-12 mb-3 text-center\">
                            <h2 class=\"separatore-inferiore\">{$this->datiLista["nome"]}</h2>
                            <p class=\"mb-4\"> {$this->datiLista["descrizione"]}</p>
                        </div>";
                            
                        //creazione elementi portfolio
                        $querySlide="SELECT * FROM geec_elementiLista WHERE idLista={$dati["idElemento"]} ORDER BY posizione";
                        $risElementi = parent::getDb()->eseguiQueryLettura($querySlide);

                        if($risElementi->num_rows==0) {
                           echo"<h2>Attenzione, non sono presenti elementi in questa lista. Crearli dal pannello amministrativo</h2>";
                        }

                        if($this->datiLista["tipoVisualizzazione"]=="sequenza, una colonna") {
                           $this->stampaElementiInSequenza($risElementi);
                        }
                        else if($this->datiLista["tipoVisualizzazione"]=="sequenza, riga semplice") {
                           $this->stampaElementiInSequenzaRigaSemplice($risElementi);
                        }
                        else if($this->datiLista["tipoVisualizzazione"]=="sequenza, due colonne") {
                           $this->stampaElementiInSequenzaDueColonne($risElementi);
                        }
                        else if($this->datiLista["tipoVisualizzazione"]=="fisarmonica, una colonna") {
                           $this->stampaElementiUnaColonna($risElementi);
                        }
                        else if($this->datiLista["tipoVisualizzazione"]=="fisarmonica, due colonne") {
                           $this->stampaElementiDueColonne($risElementi);
                        }
                        else {
                            echo"<h2>Attenzione, non è stato selezionato nessuno stile di visualizzazione</h2>";
                        }
                echo"</div>
                </div>";
        }
        
        function stampaElementiInSequenza($risElementi) {
            while($elemento=$risElementi->fetch_assoc()) {
                $this->stampaElementoSequenza($elemento,"");
            }
        }

        function stampaElementiInSequenzaRigaSemplice($risElementi) {
            while($elemento=$risElementi->fetch_assoc()) {
                $this->stampaElementoSequenzaRigaSemplice($elemento,"col-12");
            }
        }
        
        function stampaElementiInSequenzaDueColonne($risElementi) {
            while($elemento = $risElementi->fetch_assoc()) {
                $this->stampaElementoSequenza($elemento,"col-md-6");
            }
        }
        
        function stampaElementiUnaColonna($risElementi) {
            $contatore = 0;
            echo"<div id=\"accordion\" class=\"lista row\">";
                    while($elemento=$risElementi->fetch_assoc()) {
                        $this->stampaElementoFisarmonica($elemento,$this->aliasLista."pannello-$contatore","col-12");
                        $contatore++;
                    }
            echo"</div>";
        }
        
        function stampaElementiDueColonne($risElementi) {
            echo"<div id=\"accordion\" class=\"lista row\">";
                $contatore = 0;
                while($elemento = $risElementi->fetch_assoc()) {
                    $this->stampaElementoFisarmonica($elemento,$this->aliasLista."elemento-$contatore","col-md-6");
                    $contatore++;
                }
            echo"</div>";   
        }
        
        function stampaElementoFisarmonica($elemento, $idElemento,$classeDimensione) {
            $stringaIcona = ($this->icona!="") ? "<i class=\"$this->icona mr-3\"></i>" : "";
            echo"<div class=\"item $classeDimensione {$elemento["classeElemento"]}\">
                    <h4> <a data-toggle=\"collapse\" data-target=\"#$idElemento\" aria-expanded=\"true\" aria-controls=\"collapseOne\"> 
                         $stringaIcona {$elemento["nome"]} </a> <i class=\"fas rotate fa-angle-down fa-pull-right\"></i> 
                    </h4>
                    <hr>
                    <div id=\"$idElemento\" class=\"collapse\" aria-labelledby=\"headingOne\" data-parent=\"#accordion\">
                        <div class=\"mb-4\">{$elemento["descrizione"]}</div>
                    </div>
                </div>";
        }
        						
                                                                        
        function stampaElementoSequenza($elemento,$classeDimensione) {
            $stringaIcona   = ($this->icona!="") ? "<div class=\"col-2 align-self-center text-center\"><i class=\"$this->icona mr-3\"></i></div>" : "";
            $classeElemento = ($this->icona!="") ? "col-10 pl-0 mb-4" : "col-12 mb-4";
            echo"<div class=\"mb-3 w-100 $classeDimensione {$elemento["classeElemento"]}\">
                    <div class=\"row\">
                        $stringaIcona
                        <div class=\"$classeElemento\">
                            <h4>{$elemento["nome"]}</h4>
                            <hr>
                            {$elemento["descrizione"]}
                        </div>
                    </div>
                </div>";
        }
        
        function stampaElementoSequenzaRigaSemplice($elemento,$classeDimensione) {
            $stringaIcona = ($this->icona!="") ? "<i class=\"$this->icona mr-3\"></i>" : "";
            echo"<div class=\"row mb-4 w-100 $classeDimensione {$elemento["classeElemento"]}\">
                    <div class=\"col-md-4\">
                        <h5 class=\"d-flex align-items-center\">$stringaIcona<span>{$elemento["nome"]}</span></h5>
                    </div>
                    <div class=\"col-md-8\">
                        {$elemento["descrizione"]}
                    </div>
                </div>";
        }
    }
